using System;
using System.Data;
using BLOODUNITSTATUS = gov.va.med.vbecs.Common.VbecsTables.BloodUnitStatus;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Class BloodUnitStatus
	/// </summary>
	public class BloodUnitStatus : gov.va.med.vbecs.BOL.BaseBusinessObject
	{             
		#region Variables

		/// <summary>
		/// BloodUnitStatus table 
		/// </summary>
		private DataTable _dtUnits;

		/// <summary>
		/// Current BloodUnitStatus row
		/// </summary>
		private DataRow _drUnitStatus;
		
		#endregion

		#region Constructor

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3653"> 
		///		<ExpectedInput>Valid Guid</ExpectedInput>
		///		<ExpectedOutput>BloodUnitMedia object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3654"> 
		///		<ExpectedInput>INavlid Guid</ExpectedInput>
		///		<ExpectedOutput>New BloodUnitMedia object</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BloodUnitStatus Constructor
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		public BloodUnitStatus(System.Guid bloodUnitGuid)
		{

			_dtUnits = DAL.BloodUnitStatus.GetBloodUnitStatusByGuid(bloodUnitGuid);

			if (_dtUnits.Rows.Count > 0) 
			{
				_drUnitStatus = _dtUnits.Rows[0];
			}
			else
			{
				this.MakeNew(bloodUnitGuid);
			}
			_drUnitStatus.AcceptChanges();
			_dtUnits.ColumnChanged += new DataColumnChangeEventHandler(this.OnColumnChanged);
		}

		#endregion

		#region Methods

		/// <summary>
		/// Used to create a new instance of BloodUnitStatus if the guid wasn't found in the DB
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		private void MakeNew(System.Guid bloodUnitGuid)
		{
			if (_dtUnits == null)
			{
				throw new NullReferenceException("Unit Status DataTable is null");
			}

			_drUnitStatus = _dtUnits.NewRow();
			_drUnitStatus[BLOODUNITSTATUS.BloodUnitStatusGuid] = System.Guid.NewGuid();
			_drUnitStatus[BLOODUNITSTATUS.BloodUnitGuid] = bloodUnitGuid;
			_drUnitStatus[Common.VbecsTables.BloodUnitStatusCodeCurrent.UnitStatusCode] = string.Empty;
			_drUnitStatus[BLOODUNITSTATUS.UnitStatusDate] = System.DateTime.MinValue;
			_drUnitStatus[BLOODUNITSTATUS.UnitStatusComments] = string.Empty;
			_drUnitStatus[BLOODUNITSTATUS.DiscardCannedCommentGuid] = Guid.Empty;
			_drUnitStatus[BLOODUNITSTATUS.BiohazardousWarningIndicator] = false;
			_drUnitStatus[BLOODUNITSTATUS.QuarantineIndicator] = false;
            _drUnitStatus[BLOODUNITSTATUS.QuarantineCannedCommentGuid] = Guid.Empty; 
			_drUnitStatus[BLOODUNITSTATUS.PresumedTransfusedIndicator] = false;
			_drUnitStatus[BLOODUNITSTATUS.TestingLimitIndicator] = false;

			_drUnitStatus[BLOODUNITSTATUS.LastUpdateDate] = VBECSDateTime.GetDivisionCurrentDateTime();
			_drUnitStatus[BLOODUNITSTATUS.LastUpdateUser] = Common.LogonUser.LogonUserName;
			

			_dtUnits.Rows.Add(_drUnitStatus);
			this.IsNew = true;
		}
		//
		private void OnColumnChanged(object sender, DataColumnChangeEventArgs eventArgs)
		{
			this.IsDirty = true;
		}

		///<Developers>
		///	<Developer>Martin Tsotchev</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3658"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3745"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Checks to see whether a BloodUnitStatus is final
		/// Implements BR_13.04
		/// </summary>
		/// <returns>A boolean indicating whether a BloodUnitStatus is final</returns>
		public bool IsFinal()
		{
			if (this.UnitStatusCode == Common.UnitStatusCode.Discarded ||
				this.UnitStatusCode == Common.UnitStatusCode.Modified ||
				this.UnitStatusCode == Common.UnitStatusCode.Transferred ||
				this.UnitStatusCode == Common.UnitStatusCode.Transfused)
				return true;
			else
				return false;
		}
 
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4704"> 
		///		<ExpectedInput>Valid blood unit unique identifier</ExpectedInput>
		///		<ExpectedOutput>Data table containing previous status of unit</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4705"> 
		///		<ExpectedInput>INvalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function returns the previous status of a blood unit
		/// </summary>
		/// <param name="bloodUnitGuid">Blood unit unique identifier</param>
		/// <returns>Data table containing UnitStatusCode and UnitStatusText</returns>
		public static DataTable GetPreviousBloodUnitStatusByGuid(Guid bloodUnitGuid)
		{
			return DAL.BloodUnitStatus.GetPreviousBloodUnitStatusByGuid(bloodUnitGuid);
		}

		#endregion

        #region Properties

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3655"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3656"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BloodUnitStatusGuid
		/// </summary>
		public System.Guid BloodUnitStatusGuid
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.BloodUnitStatusGuid)) 
				{
					return System.Guid.Empty;
				}
				return (System.Guid)_drUnitStatus[BLOODUNITSTATUS.BloodUnitStatusGuid];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.BloodUnitStatusGuid] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3657"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3659"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BloodUnitGuid
		/// </summary>
		public System.Guid BloodUnitGuid
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.BloodUnitGuid)) 
				{
					return System.Guid.Empty;
				}
				return (System.Guid)_drUnitStatus[BLOODUNITSTATUS.BloodUnitGuid];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.BloodUnitGuid] = value;
			}
		}

		/// <summary>
		/// TestingLimitIndicator
		/// </summary>
		public bool TestingLimitIndicator
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.TestingLimitIndicator)) 
				{
					return false;
				}
				return (bool)_drUnitStatus[BLOODUNITSTATUS.TestingLimitIndicator];
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3660"> 
		///		<ExpectedInput>Common.UnitStatusCode</ExpectedInput>
		///		<ExpectedOutput>Common.UnitStatusCode</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3665"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// UnitStatusCode
		/// </summary>
		public Common.UnitStatusCode UnitStatusCode
		{
			get
			{
				if (_drUnitStatus.IsNull(Common.VbecsTables.BloodUnitStatusCodeCurrent.UnitStatusCode)) 
				{
					return Common.UnitStatusCode.Unknown;
				}

				return Common.Utility.GetUnitStatusCodeFromString(this._drUnitStatus[Common.VbecsTables.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString());
			}
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3666"> 
		///		<ExpectedInput>System.DateTime</ExpectedInput>
		///		<ExpectedOutput>System.DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3675"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// UnitStatusDate
		/// </summary>
		public System.DateTime UnitStatusDate  
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.UnitStatusDate)) 
				{
					return DateTime.MinValue;
				}
				return (System.DateTime)_drUnitStatus[BLOODUNITSTATUS.UnitStatusDate];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.UnitStatusDate] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3676"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3677"> 
		///		<ExpectedInput>invalid string</ExpectedInput>
		///		<ExpectedOutput>Argument Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// UnitStatusComments
		/// </summary>
		public System.String UnitStatusComments
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.UnitStatusComments)) 
				{
					return String.Empty;
				}
				return _drUnitStatus[BLOODUNITSTATUS.UnitStatusComments].ToString();
			}
			set
			{
				if (value.Length > 255) 
				{
					throw new ArgumentException("Invalid UnitStatusComments", "value");
				}
				_drUnitStatus[BLOODUNITSTATUS.UnitStatusComments] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3678"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3679"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DiscardCannedCommentGuid
		/// </summary>
		public Guid DiscardCannedCommentGuid
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.DiscardCannedCommentGuid)) 
				{
					return Guid.Empty;
				}
				return (Guid)_drUnitStatus[BLOODUNITSTATUS.DiscardCannedCommentGuid];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.DiscardCannedCommentGuid] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3680"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3681"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BiohazardousWarningIndicator
		/// </summary>
		public System.Boolean BiohazardousWarningIndicator    
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.BiohazardousWarningIndicator)) 
				{
					return false;
				}
				return (System.Boolean)_drUnitStatus[BLOODUNITSTATUS.BiohazardousWarningIndicator];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.BiohazardousWarningIndicator] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2976"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2977"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// QuarantineIndicator
		/// </summary>
		public System.Boolean QuarantineIndicator     
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.QuarantineIndicator)) 
				{
					return false;
				}
				return (System.Boolean)_drUnitStatus[BLOODUNITSTATUS.QuarantineIndicator];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.QuarantineIndicator] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3682"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3683"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// QuarantineDetailCode
		/// </summary>
		public Guid QuarantineCannedCommentGuid
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.QuarantineCannedCommentGuid)) 
				{
					return Guid.Empty;
				}
				return (Guid)_drUnitStatus[BLOODUNITSTATUS.QuarantineCannedCommentGuid];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.QuarantineCannedCommentGuid] = value;
			}
		}
		
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3684"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3685"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// LastUpdateDate
		/// CR 3195
		/// </summary>
		public new System.DateTime LastUpdateDate  
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.LastUpdateDate)) 
				{
					return DateTime.MinValue;
				}
				return (System.DateTime)_drUnitStatus[BLOODUNITSTATUS.LastUpdateDate];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.LastUpdateDate] = value;
			}
		}

		/// <summary>
		/// CR 3195
		/// </summary>
		public System.DateTime CurrentStatusLastUpdateDate
		{
			get
			{
				if (_drUnitStatus.IsNull(Common.DatabaseConstants.ArtificialColumnNames.CurrentStatusLastUpdateDate)) 
				{
					return DateTime.MinValue;
				}
				return (System.DateTime)_drUnitStatus[Common.DatabaseConstants.ArtificialColumnNames.CurrentStatusLastUpdateDate];
			}
			set
			{
				_drUnitStatus[Common.DatabaseConstants.ArtificialColumnNames.CurrentStatusLastUpdateDate] = value;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3686"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3687"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PresumedTransfusedIndicator
		/// </summary>
		public  bool PresumedTransfusedIndicator
		{
			get
			{
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.PresumedTransfusedIndicator)) 
				{
					return false;
				}
				return (bool) _drUnitStatus[BLOODUNITSTATUS.PresumedTransfusedIndicator];
			}
			set
			{
				_drUnitStatus[BLOODUNITSTATUS.PresumedTransfusedIndicator] = value;
			}
		}



		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3688"> 
		///		<ExpectedInput>byte[]</ExpectedInput>
		///		<ExpectedOutput>byte[]</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3689"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get the RowVersion of the status
		/// </summary>
		public new byte[] RowVersion
		{
			get
			{
				System.Byte[] rowVersion;
				if (_drUnitStatus.IsNull(BLOODUNITSTATUS.RowVersion))
				{
					return new byte[0];
				}
				else
				{
					rowVersion =  (byte[])(_drUnitStatus[BLOODUNITSTATUS.RowVersion]);
					return rowVersion;
				}
			}

			set
			{
				if (value == null) 
				{
					throw new ArgumentException("Invalid RowVersion", "value");
				}
				_drUnitStatus.Table.Columns[BLOODUNITSTATUS.RowVersion].ReadOnly = false;
				_drUnitStatus[BLOODUNITSTATUS.RowVersion] = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="532"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="694"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets unit status description.  This property is read-only
		/// Setting will fire change event.
		/// </summary>
		public string UnitStatusText
		{
			get
			{
				return Common.Utility.GetUnitStatusTextFromEnum(this.UnitStatusCode);
			}
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/22/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7170"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7171"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Couldn't think of a better name for this property, but it gives us code re-use for the app
		/// WorklistBuilder, BloodUnitDetailsTab, DlgSelectBloodUnits, ModifyUnits
		/// </summary>
		public string UnitStatusDescriptiveText
		{
			get
			{
				string status = this.UnitStatusText;

				if (this.QuarantineIndicator)
				{
					status = status + " (Quarantined)";
				}
				if (this.BiohazardousWarningIndicator)
				{
					status = status +" (Biohazardous)";
				}
				if (this.PresumedTransfusedIndicator)
				{
					status = "Presumed "+ status;
				}

				return(status);
			}
		}


		#endregion

        #region Implementation of IBaseBusinessObject

		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dr"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dr)
		{
			//TODO: Implement this when it's needed
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2989"> 
		///		<ExpectedInput>datarow</ExpectedInput>
		///		<ExpectedOutput>datarow</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2990"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.BiohazardousWarningIndicator))
			{
				dtRow[BLOODUNITSTATUS.BiohazardousWarningIndicator] = this.BiohazardousWarningIndicator; 
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.BloodUnitGuid))
			{
				dtRow[BLOODUNITSTATUS.BloodUnitGuid] = this.BloodUnitGuid; 
			}
			
			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.BloodUnitStatusGuid))
			{
				dtRow[BLOODUNITSTATUS.BloodUnitStatusGuid] = this.BloodUnitStatusGuid;
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.UnitStatusComments))
			{
				if (this.UnitStatusComments != string.Empty)
                    dtRow[BLOODUNITSTATUS.UnitStatusComments] = this.UnitStatusComments;
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.DiscardCannedCommentGuid))
			{
				if (this.UnitStatusCode == Common.UnitStatusCode.Discarded)
				{
					if (this.DiscardCannedCommentGuid != System.Guid.Empty)
						dtRow[BLOODUNITSTATUS.DiscardCannedCommentGuid] = this.DiscardCannedCommentGuid;
				}
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.TestingLimitIndicator))
			{
				dtRow[BLOODUNITSTATUS.TestingLimitIndicator] = this.TestingLimitIndicator; 
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.LastUpdateDate))
			{
				dtRow[BLOODUNITSTATUS.LastUpdateDate] = this.LastUpdateDate; 
			}
			
			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.LastUpdateUser))
			{
				dtRow[BLOODUNITSTATUS.LastUpdateUser] = this.LastUpdateUser;
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.QuarantineIndicator))
			{
				dtRow[BLOODUNITSTATUS.QuarantineIndicator] = this.QuarantineIndicator;
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.QuarantineCannedCommentGuid))
			{
				if (this.QuarantineIndicator)
				{
					if (this.QuarantineCannedCommentGuid != System.Guid.Empty)
						dtRow[BLOODUNITSTATUS.QuarantineCannedCommentGuid] = this.QuarantineCannedCommentGuid;
				}
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.RowVersion))
			{
				dtRow.Table.Columns[BLOODUNITSTATUS.RowVersion].ReadOnly = false;
				dtRow[BLOODUNITSTATUS.RowVersion] = this.RowVersion; 
			}

			if (dtRow.Table.Columns.Contains(Common.VbecsTables.BloodUnit.DivisionCode))
			{
				dtRow[Common.VbecsTables.BloodUnit.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.UnitStatusDate))
			{
				if (this.UnitStatusDate != System.DateTime.MinValue)
					dtRow[BLOODUNITSTATUS.UnitStatusDate] = this.UnitStatusDate;
			}

			if(dtRow.Table.Columns.Contains(BLOODUNITSTATUS.PresumedTransfusedIndicator))
			{
				dtRow[BLOODUNITSTATUS.PresumedTransfusedIndicator] = this.PresumedTransfusedIndicator;
			}

			return dtRow;
		}
        #endregion

	}
}

